// ContentsEsc_y.cpp : CContentsEsc_y Class source code
//

#include "stdafx.h"
#include "defsfile.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

IMPLEMENT_SERIAL(CContentsEsc_y, CObject, 1)



// Serialize draw data
void CContentsEsc_y::Serialize(CArchive& ar)
{
    CObject::Serialize(ar);

    if (ar.IsStoring ())
        ar.Write(&m_Data,sizeof(m_Data)) ;
    else
        ar.Read(&m_Data,sizeof(m_Data)) ;
}

// Draw to Window
void CContentsEsc_y::Draw(CDC* pDC)
{
	CGpWinPen Pen( m_Data.cDisplayColor,0) ;
	CGpWinBrush Brush(m_Data.cTile);

	CPen* pOldPen         = pDC->SelectObject((CPen* )&Pen);
	int OldBkMode         = pDC->SetBkMode( OPAQUE );
	COLORREF OldBkColor   = pDC->SetBkColor(GpToWinColor(m_Data.cBackColor));
	CBrush* pOldBrush     = pDC->SelectObject((CBrush* )&Brush);
	COLORREF OldTextColor = pDC->SetTextColor(GpToWinColor(m_Data.cDisplayColor));

	POINT
		pstPoint[DEF_MAX_POLY_NODE] ;
	for( int i = 0; i < m_Data.iCount; i++ )
	{
		pstPoint[i].x = m_Data.iX[i] ;
		pstPoint[i].y = m_Data.iY[i] ;
	}
	pDC->Polygon( pstPoint, m_Data.iCount ) ;


	pDC->SetBkMode(OldBkMode );
	pDC->SetBkColor( OldBkColor );
	pDC->SelectObject(pOldPen);
	pDC->SelectObject(pOldBrush);
	pDC->SetTextColor(OldTextColor);
}

// Transmit the data to GP
int CContentsEsc_y::Transition( CMemSock* pCMemSock)
{
	return( pCMemSock->MtoMESC_y(m_Data.cDisplayColor,m_Data.cBackColor,m_Data.cTile,m_Data.iCount,m_Data.iX,m_Data.iY)) ;
}
